; Macro library file.
; You can add your own defines or macros that will be included by all resources/libraries/etc.

;MM102's Draw Sprite Tiles Macro!

!maxtile_pointer_max        = $6180
!maxtile_pointer_high        = $6190
!maxtile_pointer_normal        = $61A0
!maxtile_pointer_low        = $61B0

; info:        YXPPCCCT
;            YX    = flip Y or X
;            PP    = Layer Priority
;            CCC    = palette
;            T    = use second page
; size:        #$00 = 8x8, #$02 = 16x16

macro maxtile(tile, xPos, yPos, info, size, pointer)

    !marco_maxtile_pointer = !{maxtile_pointer_<pointer>}

    LDX !marco_maxtile_pointer+0
    CPX !marco_maxtile_pointer+8
    BEQ +
    LDA <xPos>
    STA $400000,x
    LDA <yPos>
    STA $400001,x
    LDA <tile>
    STA $400002,x
    LDA.b <info>
    STA $400003,x
    ; Decrement slot and store back to pointer
    DEX #4
    STX !marco_maxtile_pointer+0
    LDX !marco_maxtile_pointer+2
    LDA <size>
    STA $400000,x
    ; Decrement and store back to pointer
    DEX
    STX !marco_maxtile_pointer+2
    ; End of the routine.
    +

endmacro